/*
 * AprovarLocal.java
 *
 * Created on 10 de junio de 2008, 19:55
 */

package actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class AprovarLocal extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        Local local = (Local) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            PreparedStatement sentencia = null;
            ResultSet rs = null;
            
            sentencia = con.prepareStatement("UPDATE locals SET actiu = 1, tipus = ?, preu = ?, superficie = ?, adresa = ? WHERE id = ?");
            sentencia.setString(1, local.getTipus());
            sentencia.setFloat(2, local.getPreu());
            sentencia.setFloat(3, local.getSuperficie());
            sentencia.setString(4, local.getAdresa());
            sentencia.setInt(5, local.getIdLocal());
            sentencia.executeUpdate();

            local.setError("<font color='blue'>Local aprovat correctament");
            
        }catch(Exception excepcio){
            local.setError("<font color='red'>Excepcio ocorreguda en actions.AprovarLocal:<br>" +
                    ""+excepcio.getMessage()+"</font>");
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                local.setError("<font color='red'>Excepcio ocorreguda en actions.AprovarLocal:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
        
    }
}
